implementation module CMUtilities

import StdiTasks
import StdEnv


// Utility functions
($) infixr 0 :: (a -> b) a -> b
($) f x = f x                              

maybe :: (a -> b) b (Maybe a) -> b
maybe _ x Nothing  = x
maybe f _ (Just x) = f x

mapSt :: !(.a *st -> (.b, *st)) ![.a] *st -> (![.b], *st)
mapSt f []     st = ([], st)
mapSt f [x:xs] st # (fx, st)  = f x st
                  # (fxs, st) = mapSt f xs st
                  = ([fx:fxs], st) 

concatMap :: (a -> [b]) -> [a] -> [b]
concatMap f = flatten o map f

intersperse :: a [a] -> [a]
intersperse x ys = intersperseList [x] ys

intersperseList :: [a] [a] -> [a]
intersperseList _  []     = []
intersperseList _  [y]    = [y]
intersperseList xs [y:ys] = [y] ++ xs ++ intersperseList xs ys

lookup :: a [(a,b)] -> Maybe b | == a
lookup _  []                       = Nothing
lookup x` [(x, y):xys] | x` == x   = Just y
                       | otherwise = lookup x` xys 
                       
splitBy :: (a -> Bool) [a] -> ([a], [a])
splitBy f xs = splitByRec f xs ([], [])
  where splitByRec :: (a -> Bool) [a] ([a], [a]) -> ([a], [a])
        splitByRec f []     acc       = acc
        splitByRec f [x:xs] (xs`,ys`) | f x       = splitByRec f xs (xs`, ys` ++ [x])
                                      | otherwise = splitByRec f xs (xs` ++ [x], ys`)
                       
split1 :: !String !String -> (!String, !String)
split1 sep s # res = split sep s
             = (hd res, foldr (+++) "" (intersperse sep (tl res)))                
                  
split :: !String !String -> [String]
split sep s # index = indexOf sep s
	        | index == -1 = [s]
			| otherwise   = [s % (0, index - 1) : split sep (s % (index + (size sep), size s))]  		    

indexOf :: !String !String -> Int
indexOf "" s2 = -1
indexOf s1 s2 = rec s1 s2 0
  where rec s1 s2 n | n + size s1 > size s2	                                  = -1
                    | and [s1.[i] == s2.[n + i] \\ i <- [0..((size s1) - 1)]] = n
                                                                              = rec s1 s2 (n + 1)					                               
                       
emptyTextInput :: TextInput
emptyTextInput = toTextInput ""                       
                       
toTextInput :: String -> TextInput
toTextInput s = TS 29 s

fromTextInput :: TextInput -> String
fromTextInput (TS _ s) = s

emptyTextArea :: TextArea
emptyTextArea = toTextArea ""

toTextArea :: String -> TextArea
toTextArea s = TextArea 8 40 s

fromTextArea :: TextArea -> String
fromTextArea (TextArea _ _ s) = s 

toRadioGroup :: [String] -> RadioGroup
toRadioGroup xs = RadioGroup (0, xs)

fromRadioGroup :: RadioGroup -> Int
fromRadioGroup (RadioGroup (x, _)) = x